/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world.biomes;

import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_6908;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.MHelper;
import paulevs.betternether.world.NetherBiome;
import paulevs.betternether.world.NetherBiomeConfig;
import paulevs.betternether.world.structures.StructureType;
import ru.bclib.api.biomes.BCLBiomeBuilder;
import ru.bclib.world.biomes.BCLBiomeSettings;

public class FloodedDeltas
extends NetherBiome {
    @Override
    public boolean hasStalactites() {
        return false;
    }

    public FloodedDeltas(class_2960 biomeID, class_1959 biome, BCLBiomeSettings settings) {
        super(biomeID, biome, settings);
    }

    @Override
    protected void onInit() {
        this.addStructure("blackstone_stalactite", STALACTITE_BLACKSTONE, StructureType.FLOOR, 0.2f, true);
        this.addStructure("stalactite_stalactite", STALACTITE_BASALT, StructureType.FLOOR, 0.2f, true);
        this.addStructure("blackstone_stalagmite", STALAGMITE_BLACKSTONE, StructureType.CEIL, 0.1f, true);
        this.addStructure("basalt_stalagmite", STALAGMITE_BASALT, StructureType.CEIL, 0.1f, true);
    }

    @Override
    public void genSurfColumn(class_1936 world, class_2338 pos, Random random) {
        class_2338.class_2339 POS = new class_2338.class_2339();
        POS.method_10101((class_2382)pos);
        int d = MHelper.randRange(2, 4, random);
        class_2680 state = this.isLavaValid(world, pos) ? class_2246.field_10164.method_9564() : (random.nextInt(16) > 0 ? class_2246.field_22091.method_9564() : class_2246.field_10124.method_9564());
        BlocksHelper.setWithoutUpdate(world, (class_2338)POS, state);
        if (state.method_26204() == class_2246.field_10164) {
            world.method_8392(pos.method_10263() >> 4, pos.method_10260() >> 4).method_12039((class_2338)POS.method_10103(pos.method_10263() & 0xF, pos.method_10264(), pos.method_10260() & 0xF));
        }
        POS.method_10101((class_2382)pos);
        for (int h = 1; h < d; ++h) {
            POS.method_33098(pos.method_10264() - h);
            if (!BlocksHelper.isNetherGround(world.method_8320((class_2338)POS))) break;
            BlocksHelper.setWithoutUpdate(world, (class_2338)POS, class_2246.field_22091.method_9564());
        }
    }

    protected boolean isLavaValid(class_1936 world, class_2338 pos) {
        return this.validWall(world, pos.method_10074()) && this.validWall(world, pos.method_10095()) && this.validWall(world, pos.method_10072()) && this.validWall(world, pos.method_10078()) && this.validWall(world, pos.method_10067());
    }

    protected boolean validWall(class_1936 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return BlocksHelper.isLava(state) || state.method_26234((class_1922)world, pos);
    }

    public static class Config
    extends NetherBiomeConfig {
        public Config(String name) {
            super(name);
        }

        @Override
        protected void addCustomBuildData(BCLBiomeBuilder builder) {
            builder.fogColor(104, 95, 112).loop(class_3417.field_23791).additions(class_3417.field_23790).mood(class_3417.field_23792).music(class_3417.field_23793).particles((class_2394)class_2398.field_23956, 0.12f).structure(class_6908.field_36503);
        }

        @Override
        public BCLBiomeBuilder.BiomeSupplier<NetherBiome> getSupplier() {
            return FloodedDeltas::new;
        }
    }
}

